(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21962,        630]*)
(*NotebookOutlinePosition[     22683,        655]*)
(*  CellTagsIndexPosition[     22639,        651]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Respuesta impulsiva y soluci\[OAcute]n de estado estacionario de una EDL\
\>", "Section"],

Cell[BoxData[
    \(\(ecdf = \(y'''\)[t] - 3 \( y''\)[t] - \(y'\)[t] + 
          3  y[t];\)\)], "Input"],

Cell[BoxData[
    \(imp[t_] = 
      y[t] /. \(DSolve[{ecdf \[Equal] 0, 
              y[0] \[Equal] \(y'\)[0] \[Equal] 0, \(y''\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(est[t_] = 
      y[t] /. \(DSolve[{ecdf \[Equal] Exp[t], 
                y[0] \[Equal] \(y'\)[0] \[Equal] 0 == \(y''\)[0]}, y, 
              t]\)[\([1]\)] // Expand\)], "Input"],

Cell[BoxData[
    \(\[Integral]\_0\%t Exp[x] imp[t - x] \[DifferentialD]x // 
      TrigToExp\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell[BoxData[
    \(ecu[y_, n_] := 
      Sum[c[k]*D[y[t], {t, k}], {k, 0, n}] /. c[n] \[Rule] 1\)], "Input"],

Cell[BoxData[
    \(ecu[y, 7]\)], "Input"],

Cell[BoxData[
    \(\(con[
          t_] := \[Integral]\_0\%t f[x] 
            imp[t - x] \[DifferentialD]x;\)\)], "Input"],

Cell[BoxData[
    \(D[con[t], t]\)], "Input"],

Cell[BoxData[
    \(D[con[t], {t, 2}]\)], "Input"],

Cell[BoxData[
    \(ecu[con, 4]\)], "Input"],

Cell[BoxData[{
    \(\(regla1 = 
        w_ \(\[Integral]\_0\%t f[x]*
                z__ \[DifferentialD]x\) \[RuleDelayed] \[Integral]\_0\%t f[x]*
              w*z \[DifferentialD]x;\)\), "\[IndentingNewLine]", 
    \(\(regla2 = \((\ \[Integral]\_0\%t u___*f[x]*
                  z_ \[DifferentialD]x + \[Integral]\_0\%t v___*f[x]*
                  w_ \[DifferentialD]x)\) \[RuleDelayed] \ \[Integral]\_0\%t 
                f[x]*\((u*z + v*w)\) \[DifferentialD]x;\)\)}], "Input"],

Cell[BoxData[
    \(\((Expand[ecu[con, 4]] //. regla1)\) //. regla2\)], "Input"],

Cell[BoxData[
    \(% /. Append[
        Table[\((D[imp[t], {t, k}] /. t \[Rule] 0)\) \[Rule] 0, {k, 0, 
            4 - 2}], \((D[imp[t], {t, 4 - 1}] /. t \[Rule] 0)\) \[Rule] 
          1]\)], "Input"],

Cell[BoxData[
    \(\((Expand[
            ecu[con, 4] /. 
              Append[Table[\((D[imp[t], {t, k}] /. t \[Rule] 0)\) \[Rule] 
                    0, {k, 0, 
                    4 - 2}], \((D[imp[t], {t, 4 - 1}] /. 
                      t \[Rule] 0)\) \[Rule] 1]] //. regla1)\) //. 
      regla2\)], "Input"],

Cell[BoxData[
    \(% /. \((ecu[imp, 4] /. t \[Rule] t - x)\) \[Rule] 0\)], "Input"],

Cell[BoxData[
    \(calculo[
        n_] := \[IndentingNewLine]\((\((Expand[
                  ecu[con, n] /. 
                    Append[Table[\((D[imp[t], {t, k}] /. 
                              t \[Rule] 0)\) \[Rule] 0, {k, 0, 
                          n - 2}], \((D[imp[t], {t, n - 1}] /. 
                            t \[Rule] 0)\) \[Rule] 1]] //. regla1)\) //. 
            regla2)\) /. \((ecu[imp, n] /. t \[Rule] t - x)\) \[Rule] 
          0\)], "Input"],

Cell[BoxData[
    \(calculo[4]\)], "Input"],

Cell[BoxData[
    \(calculo[16]\)], "Input"],

Cell[BoxData[
    \(condiciones[n_] := 
      Table[\((D[con[t], {t, k}] /. t \[Rule] 0)\), {k, 0, n - 1}] /. 
        Append[Table[\((D[imp[t], {t, k}] /. t \[Rule] 0)\) \[Rule] 0, {k, 0, 
              n - 2}], \((D[imp[t], {t, n - 1}] /. t \[Rule] 0)\) \[Rule] 
            1]\)], "Input"],

Cell[BoxData[
    \(condiciones[7]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Respuesta impulsiva y Delta de Dirac", "Section"],

Cell[TextData[{
  "Consideremos un sistema LTI cuya salida (output) ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " y entrada (input) ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " est\[AAcute]n relacionadas por la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0, \ d > 0\)]],
  ". Se llama ",
  StyleBox["respuesta impulsiva",
    FontSlant->"Italic"],
  " de dicho sistema a la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 0\)]],
  " con las condiciones ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = 0, \ \(y'\)[0] = 1\)]],
  ". La respuesta impulsiva depende de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`d > 0\)]],
  " y de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Se demuestra que la soluci\[OAcute]n de estado etacionario viene dada \
por la integral de convoluci\[OAcute]n  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[c, d, t - x]\),
              "TraditionalForm"], \(f[x]\), \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  ". Vamos a comprobar esto con ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "en algunos casos particulares.\na) Calcula la respuesta impulsiva, ",
  Cell[BoxData[
      \(TraditionalForm\`impulsiva[c, d, t]\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(impulsiva[c_, d_, t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ d\ y[t] \[Equal] 0, 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "b) Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = \[Lambda]\ Cos[\[Omega]\ t]\)]],
  ", comprueba que la respuesta de estado estacionario es igual a  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[c, d, t - x]\),
              "TraditionalForm"], "\[Lambda]", 
            " ", \(Cos[\[Omega]\ x]\), \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(solestacionario[c_, d_, t_] = 
      Collect[y[
            t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ 
                    d\ y[t] \[Equal] \[Lambda]\ Cos[\[Omega]\ t], 
                y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, y, 
              t]\)[\([1]\)], {\[ExponentialE]\^\(1\/2\ \((\(-c\) - \@\(c\^2 - \
4\ d\))\)\ t\), \[ExponentialE]\^\(1\/2\ \((\(-c\) + \@\(c\^2 - 4\ d\))\)\ \
t\), Cos[t\ \[Omega]], Sin[t\ \[Omega]]}, Simplify]\)], "Input"],

Cell[TextData[{
  "c) Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = Exp[\[Omega]\ t]\)]],
  ", comprueba que la respuesta de estado estacionario es igual a  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[c, d, t - x]\),
              
              "TraditionalForm"], \(Exp[\[Omega]\ x]\), \
\(\[DifferentialD]x\)}]}], TraditionalForm]]],
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(Simplify[
      Integrate[
        impulsiva[c, d, t - x]\ \[Lambda]\ Cos[\[Omega]\ x], {x, 0, 
          t}]]\), "\[IndentingNewLine]", 
    \(Simplify[% - solestacionario[c, d, t]]\)}], "Input"],

Cell[BoxData[{
    \(Simplify[
      Integrate[
        impulsiva[c, d, t - x]\ Exp[\[Omega]\ x], {x, 0, 
          t}]]\), "\[IndentingNewLine]", 
    \(Simplify[% - solestacionario[c, d, t]]\)}], "Input"],

Cell["\<\
d) Simplifica la respuesta impulsiva para el caso de ra\[IAcute]ces \
imaginarias.\
\>", "ExerciseText"],

Cell[BoxData[
    \(ComplexExpand[
        impulsiva[c, d, 
            t] /. {\((c\^2 - 4\ d)\)^\((1/2)\) \[Rule] 
              I*w, \((c\^2 - 4\ d)\)^\((\(-1\)/2)\) \[Rule] \(-I\)*
                w^\((\(-1\))\)}] /. w -> \@\(\(-c\^2\) + 4\ d\)\)], "Input"],

Cell[TextData[{
  "e) Hay una forma de interpretar la respuesta impulsiva que es muy \
intuitiva desde un punto de vista f\[IAcute]sico: la respuesta impulsiva es \
la respuesta del sistema a una fuerza externa s\[UAcute]bita e instant\
\[AAcute]nea. Matem\[AAcute]ticamente una fuerza s\[UAcute]bita e instant\
\[AAcute]nea puede aproximarse por un impulso de duraci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] > 0\)]],
  " e intensidad ",
  Cell[BoxData[
      \(TraditionalForm\`1/\[Epsilon]\)]],
  ". La siguiente funci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`impulso[t, \[Epsilon]]\)]],
  ",  permite visualizar este impulso (consulta, si es preciso, en la ayuda \
del programa la funci\[OAcute]n UnitStep[ ])."
}], "ExerciseText"],

Cell[BoxData[
    \(\(\(\(impulso[
          t_, \[Epsilon]_] = \((UnitStep[t] - 
              UnitStep[t - \[Epsilon]])\)/\[Epsilon];\)\[IndentingNewLine]
    \(\(\(Plot[impulso[t, 1/1000], {t, \(- .02\),  .02}]\) \);\)\)\( (*\ 
      observa\ la\ escala\ de\ los\ ejes\ *) \)\)\)], "Input"],

Cell[TextData[{
  "e1) Calcula, usando NDSolve[ ], la soluci\[OAcute]n de estado estacionario \
de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] = 
        impulso[t, \[Epsilon]]\)]],
  " es decir, la soluci\[OAcute]n de dicha ED que satisface las condiciones \
iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 0, \ y' \((0)\) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " en el intervalo [0,10]. LLama a esta soluci\[OAcute]n respuestaimpulso[\
\[Epsilon]].\nSugerencia: Debes usar asignaci\[OAcute]n diferida y una \
sustituci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\)\(/.\)\)\)]],
  " para que tenga sentido la expresi\[OAcute]n \
respuestaimpulso[\[Epsilon]][t] y pueda ser evaluada para valores \
num\[EAcute]ricos de \[Epsilon] y ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(respuestaimpulso[\[Epsilon]_] := 
      y /. \(NDSolve[{\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] \[Equal] 
                impulso[t, \[Epsilon]], 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, 
            y, {t, 0, 10}]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(respuestaimpulso[1]\)], "Input"],

Cell[TextData[{
  "e2) Calcula, con DSolve[ ], la respuesta impulsiva de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ y[t] = 0\)]],
  ", es decir, la soluci\[OAcute]n de dicha ED que satisface las condiciones \
iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 0, \ y' \((0)\) = 1\)]],
  ". Llama a esta funci\[OAcute]n \"respuestaimpulsiva[t]\"."
}], "ExerciseText"],

Cell[BoxData[
    \(respuestaimpulsiva[t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] \[Equal] 0, 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell["\<\
e3) Representa gr\[AAcute]ficamente, en la misma gr\[AAcute]fica, las \
funciones respuestaimpulsiva[t] y respuestaimpulso[1-\[Delta]][t] donde \
\[Delta] toma valores desde .11 hasta .99 con incrementos de .11. Comenta lo \
que ves.\
\>", "Text"],

Cell[BoxData[
    \(\(Do[
        Plot[{\(respuestaimpulso[1 - \[Delta]]\)[t], 
            respuestaimpulsiva[t]}, {t, 0, 10}, 
          PlotStyle \[Rule] {Hue[0], 
              Hue[ .65]}], {\[Delta],  .11,  .99,  .11}];\)\)], "Input"],

Cell["\<\
e4) Calcula,con DSolve[],soluci\[OAcute]n de estado estacionario de la \
EDy''[t]+y'[t]+ y[t]=UnitStep[t]/\[Epsilon].Llama a esta funci\[OAcute]n \
\"sol1[t,\[Epsilon]]\".\
\>", "Text"],

Cell[BoxData[
    \(sol1[\[Epsilon]_, t_] = 
      Collect[y[
              t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + \ y[t] \[Equal] 
                    UnitStep[t]/\[Epsilon], 
                  y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}\ , y, t]\)[\([1]\)] // 
          Simplify, {Cos[x_], Sin[x_]}, Simplify]\)], "Input"],

Cell[TextData[{
  "e5) Calcula, con DSolve[ ], la soluci\[OAcute]n de estado estacionario de \
la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ y[t] = 
        UnitStep[t - \[Epsilon]]/\[Epsilon]\)]],
  ". Llama a esta funci\[OAcute]n \"sol2[t,\[Epsilon]]\". ",
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`sol1[t, \[Epsilon]] - sol2[t, \[Epsilon]]\)]],
  " es la soluci\[OAcute]n de estado estacionario de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ 
          y[t] = \(\(impulso[t, \[Epsilon]]\)\(.\)\)\)]]
}], "Text"],

Cell[BoxData[
    \(sol2[\[Epsilon]_, t_] = 
      Collect[y[
              t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + \ y[t] \[Equal] 
                    UnitStep[t - \[Epsilon]]/\[Epsilon], 
                  y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}\ , y, t]\)[\([1]\)] // 
          Simplify, {Cos[x_], Sin[x_]}, Simplify]\)], "Input"],

Cell[TextData[{
  "e6) Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(Lim\_\(\[Epsilon] \[Rule] 0\)\)(
          sol1[t, \[Epsilon]] - sol2[t, \[Epsilon]])\)\(\ \)\(=\)\)\)]],
  "respuestaimpulsiva[t]UnitStep[t]."
}], "ExerciseText"],

Cell[BoxData[
    \(Limit[%, \[Epsilon] \[Rule] 0, Direction \[Rule] \(-1\)]\)], "Input"],

Cell[TextData[{
  "A la vista de estos resultados, parece claro que la respuesta impulsiva \
del sistema es el l\[IAcute]mite para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  " de la respuesta estacionaria del sistema al \"impulso de duraci\[OAcute]n \
\[Epsilon]\", impulso[t,\[Epsilon]]. Llamemos, ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t)\)]],
  " a la primera e ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t, \[Epsilon])\)]],
  " a la segunda. Seg\[UAcute]n acabamos de ver, ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t) = 
        lim\_\(\[Epsilon] \[Rule] 0\)\(y\_imp\)(t, \[Epsilon])\)]],
  ". Por otra parte, se verificar\[AAcute] que"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t, \[Epsilon])\) + 
        y\_imp' \((t, \[Epsilon])\) + \(y\_imp\)(t, \[Epsilon]) = 
      impulso(t, \[Epsilon]), \ \(y\_imp\)(0, \[Epsilon]) = 0, \ 
    y\_imp' \((0, \[Epsilon])\) = 0\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t)\) + y\_imp' \((t)\) + \(y\_imp\)(t) = 
      0, \(y\_imp\)(0) = 
      0, \ \(\(y\_imp' \((0)\)\)\(=\)\(1\)\(\ \)\)\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[{
  "\[DownQuestion]No es absolutamente tentador tomar l\[IAcute]mites en la \
primera de estas EDs para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  "? Veamos. Aqu\[IAcute] hay algunas dificultades matem\[AAcute]ticas. La \
primera es que la operaci\[OAcute]n de derivar rara vez conmuta con la de \
paso al l\[IAcute]mite. En general, no es lo mismo derivar primero y tomar l\
\[IAcute]mite despu\[EAcute]s que invertir el proceso. Pero hay otra \
dificultad que salta a la vista: la condici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(y\_imp' \((0, \[Epsilon])\) = 0\)\)\)]],
  " dif\[IAcute]cilmente se puede convertir en el l\[IAcute]mite en la \
condici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y\_imp' \((0)\) = 1. \ Adem\[AAcute]s\), ",", " ", 
          RowBox[{"se", " ", "tiene", " ", "que", " ", Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(\(lim\_\(\[Epsilon] \[Rule] 0\)impulso(
                        t, \[Epsilon])\)\(=\)\(0\)\(\ \)\)\)]],
              "para todo ",
              Cell[BoxData[
                  \(TraditionalForm\`t \[NotEqual] 0\)]],
              ", mientras "
            }]], "que", " "}]}], TraditionalForm]]],
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(\[Epsilon] \[Rule] 0\)impulso(
            0, \[Epsilon]) = \(+\[Infinity]\)\)]],
  ". Pero dejemos hablar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(Limit[impulso[t, \[Epsilon]], \[Epsilon] \[Rule] 0, 
      Direction \[Rule] \(-1\), 
      Assumptions \[Rule] t \[NotEqual] 0]\), "\[IndentingNewLine]", 
    \(Limit[impulso[0, \[Epsilon]], \[Epsilon] \[Rule] 0, 
      Direction \[Rule] \(-1\)]\)}], "Input"],

Cell["\<\
Por otra parte, observa que lo que estamos calculando es una derivada.\
\>", "ExerciseText"],

Cell[BoxData[
    \(impulso[t, \[Epsilon]] /. \[Epsilon] \[Rule] \(-\[Epsilon]\) // 
      Simplify\)], "Input"],

Cell[TextData[{
  "Este l\[IAcute]mite es, por definici\[OAcute]n, la derivada de la funci\
\[OAcute]n UnitStep[ ] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Esa derivada no tiene ning\[UAcute]n problema en puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t \[NotEqual] 0\)]],
  " pero para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " no existe (o vale ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)]],
  "). Veamos lo que sabe ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de la derivada de la funci\[OAcute]n UnitStep[ ]."
}], "Text"],

Cell[BoxData[
    \(D[UnitStep[t], t]\)], "Input"],

Cell["\<\
\[DownExclamation]Acaba de aparecer la famos\[IAcute]sima \"delta de Dirac\". \
Veamos algo sobre ella.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(DiracDelta[34]\), "\[IndentingNewLine]", 
    \(DiracDelta[\(-2.89\)]\), "\[IndentingNewLine]", 
    \(DiracDelta[0]\), "\[IndentingNewLine]", 
    \(\(Plot[DiracDelta[t], {t, \(-1000\), 1000}];\)\)}], "Input"],

Cell[BoxData[
    \(y[t] /. \(DSolve[{\(y''\)[t] + \(y'\)[t] + y[t] \[Equal] DiracDelta[t], 
            y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
          t]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(respuestaimpulso[\[Epsilon]_] := 
      y /. \(NDSolve[{\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] \[Equal] 
                impulso[t, \[Epsilon]], 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, 
            y, {t, 0, 10}]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(respuestaimpulsiva[t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] \[Equal] 0, 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(respuestaimpulso[1]\)], "Input"],

Cell[BoxData[
    \(\(Do[
        Plot[{\(respuestaimpulso[1 - \[Delta]]\)[t], 
            respuestaimpulsiva[t]}, {t, 0, 10}, 
          PlotStyle \[Rule] {Hue[0], 
              Hue[ .65]}], {\[Delta],  .11,  .99,  .11}];\)\)], "Input"],

Cell[BoxData[
    \(sol[\[Epsilon]_, t_] = 
      Collect[Simplify[
          sol1[\[Epsilon], t] - sol2[\[Epsilon], t], \[Epsilon] > 0], {Cos[
            x_], Sin[x_]}, Simplify]\)], "Input"],

Cell[BoxData[
    \(impulsiva[c_, d_, t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ d\ y[t] \[Equal] 0, 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(solestacionario[c_, d_, t_] = 
      Collect[y[
            t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ 
                    d\ y[t] \[Equal] \[Lambda]\ Cos[\[Omega]\ t], 
                y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, y, 
              t]\)[\([1]\)], {\[ExponentialE]\^\(1\/2\ \((\(-c\) - \@\(c\^2 - \
4\ d\))\)\ t\), \[ExponentialE]\^\(1\/2\ \((\(-c\) + \@\(c\^2 - 4\ d\))\)\ \
t\), Cos[t\ \[Omega]], Sin[t\ \[Omega]]}, Simplify]\)], "Input"],

Cell[BoxData[{
    \(Simplify[
      Integrate[
        impulsiva[c, d, t - x]\ \[Lambda]\ Cos[\[Omega]\ x], {x, 0, 
          t}]]\), "\[IndentingNewLine]", 
    \(Simplify[% - solestacionario[c, d, t]]\)}], "Input"],

Cell[BoxData[{
    \(Clear[solestacionario]\), "\[IndentingNewLine]", 
    \(solestacionario[c_, d_, t_] = 
      Collect[y[
            t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ d\ y[t] \[Equal] 
                  Exp[\[Omega]\ t], y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, 
              y, t]\)[\([1]\)], {\[ExponentialE]\^\(1\/2\ \((\(-c\) - \
\@\(c\^2 - 4\ d\))\)\ t\), \[ExponentialE]\^\(1\/2\ \((\(-c\) + \@\(c\^2 - 4\ \
d\))\)\ t\), Cos[t\ \[Omega]], Sin[t\ \[Omega]]}, Simplify]\)}], "Input"],

Cell[BoxData[{
    \(Simplify[
      Integrate[
        impulsiva[c, d, t - x]\ Exp[\[Omega]\ x], {x, 0, 
          t}]]\), "\[IndentingNewLine]", 
    \(Simplify[% - solestacionario[c, d, t]]\)}], "Input"],

Cell[BoxData[
    \(ComplexExpand[
        impulsiva[c, d, 
            t] /. {\((c\^2 - 4\ d)\)^\((1/2)\) \[Rule] 
              I*w, \((c\^2 - 4\ d)\)^\((\(-1\)/2)\) \[Rule] \(-I\)*
                w^\((\(-1\))\)}] /. w -> \@\(\(-c\^2\) + 4\ d\)\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 99, 2, 93, "Section"],
Cell[1878, 57, 105, 2, 72, "Input"],
Cell[1986, 61, 189, 4, 72, "Input"],
Cell[2178, 67, 199, 4, 98, "Input"],
Cell[2380, 73, 106, 2, 92, "Input"],
Cell[2489, 77, 47, 1, 72, "Input"],
Cell[2539, 80, 109, 2, 72, "Input"],
Cell[2651, 84, 42, 1, 72, "Input"],
Cell[2696, 87, 124, 3, 92, "Input"],
Cell[2823, 92, 45, 1, 72, "Input"],
Cell[2871, 95, 50, 1, 72, "Input"],
Cell[2924, 98, 44, 1, 72, "Input"],
Cell[2971, 101, 485, 8, 142, "Input"],
Cell[3459, 111, 80, 1, 72, "Input"],
Cell[3542, 114, 203, 4, 98, "Input"],
Cell[3748, 120, 316, 7, 98, "Input"],
Cell[4067, 129, 84, 1, 72, "Input"],
Cell[4154, 132, 466, 9, 150, "Input"],
Cell[4623, 143, 43, 1, 72, "Input"],
Cell[4669, 146, 44, 1, 72, "Input"],
Cell[4716, 149, 292, 5, 124, "Input"],
Cell[5011, 156, 47, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5095, 162, 55, 0, 93, "Section"],
Cell[5153, 164, 1600, 48, 180, "ExerciseText"],
Cell[6756, 214, 216, 4, 98, "Input"],
Cell[6975, 220, 500, 14, 68, "ExerciseText"],
Cell[7478, 236, 475, 8, 173, "Input"],
Cell[7956, 246, 466, 14, 68, "ExerciseText"],
Cell[8425, 262, 217, 5, 98, "Input"],
Cell[8645, 269, 206, 5, 98, "Input"],
Cell[8854, 276, 114, 3, 41, "ExerciseText"],
Cell[8971, 281, 260, 5, 137, "Input"],
Cell[9234, 288, 772, 16, 119, "ExerciseText"],
Cell[10009, 306, 293, 5, 124, "Input"],
Cell[10305, 313, 923, 24, 153, "ExerciseText"],
Cell[11231, 339, 268, 5, 124, "Input"],
Cell[11502, 346, 52, 1, 72, "Input"],
Cell[11557, 349, 410, 9, 67, "ExerciseText"],
Cell[11970, 360, 215, 4, 98, "Input"],
Cell[12188, 366, 257, 5, 67, "Text"],
Cell[12448, 373, 239, 5, 98, "Input"],
Cell[12690, 380, 195, 4, 41, "Text"],
Cell[12888, 386, 324, 6, 150, "Input"],
Cell[13215, 394, 602, 14, 87, "Text"],
Cell[13820, 410, 337, 6, 150, "Input"],
Cell[14160, 418, 313, 9, 41, "ExerciseText"],
Cell[14476, 429, 89, 1, 72, "Input"],
Cell[14568, 432, 730, 17, 93, "ExerciseText"],
Cell[15301, 451, 298, 5, 38, "ExerciseText"],
Cell[15602, 458, 228, 4, 38, "ExerciseText"],
Cell[15833, 464, 1509, 33, 171, "ExerciseText"],
Cell[17345, 499, 281, 5, 98, "Input"],
Cell[17629, 506, 102, 2, 41, "ExerciseText"],
Cell[17734, 510, 112, 2, 72, "Input"],
Cell[17849, 514, 607, 18, 67, "Text"],
Cell[18459, 534, 50, 1, 72, "Input"],
Cell[18512, 537, 135, 3, 41, "ExerciseText"],
Cell[18650, 542, 231, 4, 150, "Input"],
Cell[18884, 548, 185, 3, 98, "Input"],
Cell[19072, 553, 268, 5, 124, "Input"],
Cell[19343, 560, 215, 4, 98, "Input"],
Cell[19561, 566, 52, 1, 72, "Input"],
Cell[19616, 569, 239, 5, 98, "Input"],
Cell[19858, 576, 193, 4, 98, "Input"],
Cell[20054, 582, 216, 4, 98, "Input"],
Cell[20273, 588, 475, 8, 173, "Input"],
Cell[20751, 598, 217, 5, 98, "Input"],
Cell[20971, 605, 503, 8, 199, "Input"],
Cell[21477, 615, 206, 5, 98, "Input"],
Cell[21686, 622, 260, 5, 137, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

